using System;
using System.IO;
using DynaPDF;

namespace examples
{
	class Class1
	{
      /*
         Note that the dynapdf.dll must be copied into the output directory or into a
         Windwos search path (e.g. %WINDOWS%/System32) before the application can be executed!
      */

      // Error callback function.
      // If the function name should not appear at the beginning of the error message then set
      // the flag emNoFuncNames (pdf.SetErrorMode(DynaPDF.TErrMode.emNoFuncNames);).
      static int PDFError(IntPtr Data, int ErrCode, IntPtr ErrMessage, int ErrType)
      {
         Console.Write("{0}\n", System.Runtime.InteropServices.Marshal.PtrToStringAnsi(ErrMessage));
         return 0; // We try to continue if an error occurrs. Any other return value breaks processing.
      }

		[STAThread]
		static void Main(string[] args)
		{
         try
         {
            CPDF pdf = new CPDF();
            // Error messages and warnings are passed to the callback function.
            pdf.SetOnErrorProc(IntPtr.Zero, new DynaPDF.TErrorProc(PDFError));
            pdf.CreateNewPDF(null); // We open the output file later if no error occurrs.

            // Set the license key here if you have one
            // pdfSetLicenseKey(pdf, "");

            // We assume that the pdf invoice is already a valid PDF/A 3 file in this example.

            pdf.SetImportFlags(TImportFlags.ifImportAsPage | TImportFlags.ifImportAll);
            pdf.OpenImportFile("../../../../test_files/test_invoice.pdf", TPwdType.ptOpen, null);

            pdf.ImportPDFFile(1, 1.0, 1.0);

            int ef = pdf.AttachFile("../../../../test_files/factur-x.xml", "EN 16931 compliant invoice", false);
            pdf.AssociateEmbFile(TAFDestObject.adCatalog, -1, TAFRelationship.arAlternative, ef);

            /* Note that ZUGFeRD 2.1 or higher and FacturX is identically defined in PDF. Therefore, both formats share
               the same version constants. Note also that the profiles Minimum, Basic, and Basic WL are not fully EN 16931
               compliant and hence cannot be used to create e-invoices.
            */
            pdf.SetPDFVersion(TPDFVersion.pvFacturX_Comfort);

            // No fatal error occurred?
            if (pdf.HaveOpenDoc())
            {
               // We write the output file into the current directory.
               String filePath = Directory.GetCurrentDirectory() + "\\out.pdf";
               // OK, now we can open the output file.
               if (!pdf.OpenOutputFile(filePath)) return;
               if (pdf.CloseFile())
               {
                  Console.Write("PDF file \"{0}\" successfully created!\n", filePath);
                  System.Diagnostics.Process p = new System.Diagnostics.Process();
                  p.StartInfo.FileName = filePath;
                  p.Start();
               }
            }
            pdf = null;
         }catch(Exception e)
         {
            Console.Write(e.Message);
            Console.Read();
         }
		}
	}
}
